/**
 * @file        svg_font_config.h
 *
 * @version     $Id: svg_font_config.h,v 1.6.46.1 2012/02/21 11:58:12 efriedrich Exp $
 *
 * @brief       This header file configurats the module.
 *
 * Implement here new font modules. Therefore you should declare\n
 * the header of the module. Additionally you could declare fixed supported\n
 * fonts in the flash_fonts struct.
 *
 * @author      D.Langner  / ADIT-G / SWG / dlangner@de.adit-jv.com
 *              C.Spetzler / ADIT-G / SWG / cpspetzler@de.adit-jv.com
 *
 * @copyright   (c) 2003 - 2006 ADIT Corporation
 *
 * @see         <related items>
 *
 ******************************************************************************/
#ifndef     __SVG_FONT_CONFIG_H__
#define     __SVG_FONT_CONFIG_H__


/**
 * @brief   Declaration of modules:
 *
 * Here you have to declare font module header files.
 */
#include "grlft_font.h"         /**< Freetype font module                     */


/**
 * @brief   Flash font files for the moduls.
 */
#include  "chicago.h"           /**< system fonts for Freetype Plugin         */


/**
 * @def  Number of available system fonts.
 */
#define GRL_FLASH_FONT_COUNT    1   /**< Number of available system fonts.    */


/**
 * @def  Number of font directories.
 */
#define SVG_MAXPATH             1   /**< Number of font directories.          */

#define SVG_DEFAUTL_TEXTURE_SIZE 4096
/**
 * @def  maximum font size, bigger values are truncated to this value
 */
#define SVG_MAX_FONT_SIZE       100

/**
 * @def  Used font suffixes
 */
#define FT_NR_OF_SUP_SUFFIXES   3
#define FT_SUPPORTED_SUFFIXES   ".otf\t.ttf\t.ttc\t.ccc\t.ltt\t"

/**
 * @def  Used font reading data from parsed file with below offsets
 */
#define PARSED_FLASHFONTS		11
#define PARSED_FILEFONTS		22

/**
 * @param    flash_fonts[]  : Font declaration list.
 *
 * Declare in this global flash_font list your flash files.\n
 * Type grl_flash_font is declared as follows:
 *
 * @param   SVGInt8*    : Declare the suffix.
 * @param   SVGUint8*   : Start address of font.
 * @param   SVGInt32    : Size of font.
 *
 * @note    If you added a flash font, than change the GRL_FLASH_FONT_COUNT\n
 *          param.
 */
static
grl_flash_font const flash_fonts[GRL_FLASH_FONT_COUNT] =
    {
        {(SVGInt8*)".ttf", &chicago[0][0]     , 97052}
    };


/**
 * @param   svgPathNames    : Pathes for searching fonts.
 *
 * @note    If you added a path, than change the SVG_MAXPATH param.
 */
extern SVGChar svgPathNames[SVG_MAXPATH][256];
                /**< for component test work with host file system.           */

/**
 * @param   svgPathNames    : Pathes for searching fonts.
 *
 * @note    If you added a path, than change the SVG_MAXPATH param.
 */
extern SVGChar*  parsed_file_buffer;
extern SVGUint32 parsed_file_buffer_size;

#endif  /* __SVG_FONT_CONFIG_H__ */
